@extends('layouts.app')

@section('title', 'Forum')

@section('content')
<div class="forum-container">
    <div class="forum-header">
        <h1>Forums</h1>
        <p>Discuss gameplay, get help, and connect with other players</p>
    </div>
    
    <div class="forum-stats">
        <div class="row">
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-value">{{ \App\Models\ForumThread::count() }}</div>
                    <div class="stat-label">Total Threads</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-value">{{ \App\Models\ForumPost::count() }}</div>
                    <div class="stat-label">Total Replies</div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <div class="stat-value">{{ \App\Models\User::count() }}</div>
                    <div class="stat-label">Community Members</div>
                </div>
            </div>
        </div>
    </div>
    
    @forelse($categories as $category)
        {{-- Only show categories the user can access --}}
        @if($category->canAccess())
            <div class="forum-category">
                <div class="forum-category-header">
                    <h2>{{ $category->name }}</h2>
                    @if($category->description)
                        <p>{{ $category->description }}</p>
                    @endif
                    {{-- Show access indicator for restricted categories --}}
                    @if(!$category->is_public)
                        <div class="forum-access-indicator">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                            <span>Restricted Access</span>
                        </div>
                    @endif
                </div>
                <div class="forum-category-boards">
                    {{-- Use accessibleBoards instead of boards --}}
                    @forelse($category->accessibleBoards as $board)
                        {{-- Double-check board access (defensive programming) --}}
                        @if($board->canAccess())
                            <div class="forum-board">
                                <div class="forum-board-icon">
                                    {{-- Show different icon for restricted boards --}}
                                    @if(!$board->is_public)
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                                        </svg>
                                    @else
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z" />
                                        </svg>
                                    @endif
                                </div>
                                <div class="forum-board-info">
                                    <h3>
                                        <a href="{{ route('forum.board', $board->slug) }}">{{ $board->name }}</a>
                                        {{-- Show access indicator for restricted boards --}}
                                        @if(!$board->is_public)
                                            <span class="forum-restricted-badge" title="Restricted Access">🔒</span>
                                        @endif
                                    </h3>
                                    <p>{{ $board->description }}</p>
                                </div>
                                <div class="forum-board-stats">
                                    <div class="threads">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 8h10M7 12h4m1 8l-4-4H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-3l-4 4z" />
                                        </svg>
                                        {{ $board->threadCount() }} Threads
                                    </div>
                                    <div class="posts">
                                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8h2a2 2 0 012 2v6a2 2 0 01-2 2h-2v4l-4-4H9a1.994 1.994 0 01-1.414-.586m0 0L11 14h4a2 2 0 002-2V6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2v4l.586-.586z" />
                                        </svg>
                                        {{ $board->postCount() }} Posts
                                    </div>
                                </div>
                                <div class="forum-board-latest">
                                    @if($latestThread = $board->latestThreads()->first())
                                        <div class="thread">
                                            <a href="{{ route('forum.thread', [$board->slug, $latestThread->slug]) }}">{{ \Illuminate\Support\Str::limit($latestThread->title, 25) }}</a>
                                        </div>
                                        <div class="meta">
                                            by <a href="{{ route('users.show', $latestThread->user->slug) }}">{{ $latestThread->user->name }}</a> • 
                                            {{ $latestThread->created_at->diffForHumans() }}
                                        </div>
                                    @else
                                        <div class="thread">No threads yet</div>
                                    @endif
                                </div>
                            </div>
                        @endif
                    @empty
                        <div class="forum-board">
                            <div class="forum-board-info">
                                <h3>No accessible boards</h3>
                                <p>You don't have permission to view boards in this category.</p>
                            </div>
                        </div>
                    @endforelse
                </div>
            </div>
        @endif
    @empty
        <div class="forum-category">
            <div class="forum-category-header">
                <h2>No Forums Available</h2>
            </div>
            <div class="forum-category-boards">
                <div class="forum-board">
                    <div class="forum-board-info">
                        <h3>Access Restricted</h3>
                        <p>
                            @auth
                                You don't have permission to view any forum categories. Contact an administrator if you believe this is an error.
                            @else
                                <a href="{{ route('login.steam') }}">Login</a> to access forum discussions.
                            @endauth
                        </p>
                    </div>
                </div>
            </div>
        </div>
    @endforelse

    {{-- Show helpful message for guests --}}
    @guest
        <div class="forum-guest-notice">
            <div class="forum-guest-notice-content">
                <h3>🔐 Join the Community</h3>
                <p>Some forum areas may require <a href="{{ route('login.steam') }}">Steam login</a> to access. Sign in to see all available discussions!</p>
            </div>
        </div>
    @endguest
</div>
@endsection